Include([[Data/levels/include/level_utils.lua]])
Include([[Data/levels/include/random_achieve.lua]])

Level =
{
	MapSkinFilename = LevelUtils.PickRandomChoice(LevelUtils.GetAllSkinFilenames()),
	MapGenScript = function ()
	
		MapGeometry:Randomize(50000)
		
		LevelUtils.MapGenDefaults.CapPtDangerRadius = 31.0
		LevelUtils.MapGenDefaults.CapPtControlRadius = 80.0
		
		MapEntities:SetParameters(LevelUtils.MapGenDefaults)
		MapEntities:GenerateLocations()
	
		--Capture point placement
		for i=1, 6 do
			MapEntities:PlaceCapPoint(false, -1, 0, true, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
		end
		
		MapEntities:PlaceCapPoint(false, 1, math.huge, true, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
		MapEntities:PlaceCapPoint(false, 2, math.huge, true, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
		
		local homeBase = MapEntities:PlaceCapPoint(true, -1, 0, false, 80.0, "");
		GameWorld:AddMarines(homeBase:GetPos(), GameWorld:GetStartingTeamSize())
		GameWorld:ResetCamera(homeBase:GetPos())
		--GameWorld:FocusCameraOn(homeBase)
		
		--Place crates
		for i=1, 2 do
			MapEntities:PlaceBPCrate(20.0, 60.0, 15.0);
		end
		
		for i=1, 2 do
			MapEntities:PlaceAPCrate(14.0, 20.0, 6.0);
		end		
	end,
	
	Parameters =
	{
		MarineCount 		= 5,
		MaxHiveLevel 		= 3,
		MaxSpawnRate 		= 12.0,
		StartBPMultiplier 	= 1.17,
		BPGainMultiplier    = 1.0,
		
		DefaultHiveTowerCount = 6,
	},
	Rules = 
	{
		AutoCapture 	= false,		--Destroying hives automatically counts as a capture
		NoPushback		= false,		--Can the player's points be captured?
		NoTowerRespawn  = false,        --Can the hive towers respawn?
		WeakenHiveOnCap = false,        --Do captures halve defensive strength?
		DisableLockdown = false,        --Turn off emergency help is player is behind
	},
	Mutations =
	{
		CapturesPerMutation = 2,
		MaxMutations = 4,
		Default = [[disabled]],
		Active =
		{
		},
		Inactive =
		{
            [[ZU_SLOWING_POISON]],
            [[ZU_REGENERATION]],		
            [[ZU_ZOMBIE_MINES]],	
            [[ZU_RUST]],

            [[ZU_BOMBARDMENT]],
            [[ZU_HIVE_SPIKES]],		
            [[ZU_WALK_SPEED]],	
            [[ZU_REVIVAL]],
            [[ZU_SPIKE_POWER]],
            [[ZU_MARTYRDOM]],		
		},		
		Queue =
		{
		},
		Disabled =
		{
		},
		Randomize = true
	},
	MarineUpgrades = 
	{
		Active =
		{
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	},
	
	OnDebugCall = function (mousePos)
	end
}


------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		
		CaptureAllObjective:Enable()
		
		self:Disable()
	end)
LevelInit:Enable()


------------------------------------------------------------------------------- Tracked objective for capturing everything
CaptureAllObjective = LevelUtils.MakeGoal(
	function (self)
		GameWorld:SetUIVisibility("Objectives", true)
		GameWorld:AddObjective("winObj", "Capture all the enemy points")
			
	end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[complete]])
	
		self:Disable()
	end)
	
------------------------------------------------------------------------------- Victory Condition - Capture All Points (short-circuit)
CaptureAllGoal = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ClearText()
		GameWorld:GameOver(true)
		
		self:Disable()
	end) 
CaptureAllGoal:Enable()

------------------------------------------------------------------------------- Lost all points
LossCondition = LevelUtils.MakeGoal(
	function (self)	
	end,
	
	{[[NT_ALL_POINTS_LOST]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[failed]])
	
		GameWorld:ClearText()
		GameWorld:GameOver(false)
	
		CaptureAllGoal:Disable()
	
		self:Disable()
	end)
LossCondition:Enable()
